/*
Copyright ＿ 2005, Apple Computer, Inc.  All rights reserved.
NOTE:  Use of this source code is subject to the terms of the Software
License Agreement for Mac OS X, which accompanies the code.  Your use
of this source code signifies your agreement to such license terms and
conditions.  Except as expressly granted in the Software License Agreement
for Mac OS X, no other copyright, patent, or other intellectual property
license or right is granted, either expressly or by implication, by Apple.
*/

var defaultCityIndex = 8;
var defaultContinentIndex = 5;
var SouthAmerica = [
	{city:'Asunción', offset:-240, timezone:'America/Asuncion'},
	{city:'Bogotá', offset:-300, timezone:'America/Bogota'},
	{city:'Brasília', offset:-180, timezone:'Brazil/East'},
	{city:'Buenos Aires', offset:-180, timezone:'America/Buenos_Aires'},
	{city:'Caracas', offset:-240, timezone:'America/Caracas'},
	{city:'Cayenne', offset:-180, timezone:'America/Cayenne'},
	{city:'Georgetown', offset:-240, timezone:'America/Guyana'},
	{city:'La Paz', offset:-240, timezone:'America/La_Paz'},
	{city:'Lima', offset:-300, timezone:'America/Lima'},
	{city:'Montevideo', offset:-180, timezone:'America/Montevideo'},
	{city:'Paramaribo', offset:-180, timezone:'America/Paramaribo'},
	{city:'Quito', offset:-300, timezone:'America/Guayaquil'},
	{city:'Recife', offset:-180, timezone:'America/Recife'},
	{city:'Rio de Janeiro', offset:-180, timezone:'Brazil/East'},
	{city:'San Juan', offset:-240, timezone:'America/Puerto_Rico'},
	{city:'Santiago', offset:-240, timezone:'America/Santiago'},
	{city:'São Paulo', offset:-180, timezone:'America/Sao_Paulo'}
];
var Pacific = [
	{city:'Guam', offset:600, timezone:'Pacific/Guam'},
	{city:'Honolulu', offset:-600, timezone:'Pacific/Honolulu'},
	{city:'Nouméa', offset:660, timezone:'Pacific/Noumea'},
	{city:'Pago Pago', offset:-660, timezone:'Pacific/Pago_Pago'},
	{city:'Wellington', offset:720, timezone:'Pacific/Auckland'}
];
var Atlantic = [
	{city:'Grytviken', offset:-120, timezone:'Atlantic/South_Georgia'},
	{city:'Ponta Delgada', offset:0, timezone:'Atlantic/Azores'},
	{city:'Reykjavík', offset:0, timezone:'Atlantic/Reykjavik'}
];
var Europe = [
	{city:'Amsterdam', offset:120, timezone:'Europe/Amsterdam'},
	{city:'Athens', offset:180, timezone:'Europe/Athens'},
	{city:'Belgrade', offset:180, timezone:'Europe/Belgrade'},
	{city:'Berlin', offset:120, timezone:'Europe/Berlin'},
	{city:'Brussels', offset:120, timezone:'Europe/Brussels'},
	{city:'Bucharest', offset:180, timezone:'Europe/Bucharest'},
	{city:'Budapest', offset:120, timezone:'Europe/Budapest'},
	{city:'Cardiff', offset:60, timezone:'Europe/London'},
	{city:'Copenhagen', offset:120, timezone:'Europe/Copenhagen'},
	{city:'Cork', offset:60, timezone:'Europe/Dublin'},
	{city:'Dublin', offset:60, timezone:'Europe/Dublin'},
	{city:'Edinburgh', offset:60, timezone:'Europe/London'},
	{city:'Geneva', offset:120, timezone:'Europe/Zurich'},
	{city:'Helsinki', offset:180, timezone:'Europe/Helsinki'},
	{city:'Istanbul', offset:180, timezone:'Asia/Istanbul'},
	{city:'Kiev', offset:180, timezone:'Europe/Kiev'},
	{city:'Lisbon', offset:60, timezone:'Europe/Lisbon'},
	{city:'Ljubljana', offset:120, timezone:'Europe/Ljubljana'},
	{city:'London', offset:60, timezone:'Europe/London'},
	{city:'Madrid', offset:120, timezone:'Europe/Madrid'},
	{city:'Moscow', offset:240, timezone:'Europe/Moscow'},
	{city:'Munich', offset:120, timezone:'Europe/Berlin'},
	{city:'Oslo', offset:120, timezone:'Europe/Oslo'},
	{city:'Paris', offset:120, timezone:'Europe/Paris'},
	{city:'Prague', offset:120, timezone:'Europe/Prague'},
	{city:'Roma (Rome)', offset:120, timezone:'Europe/Rome'},
	{city:'Sofia', offset:180, timezone:'Europe/Sofia'},
	{city:'St. Petersburg', offset:240, timezone:'Europe/Moscow'},
	{city:'Stockholm', offset:120, timezone:'Europe/Stockholm'},
	{city:'Vienna', offset:120, timezone:'Europe/Vienna'},
	{city:'Volgograd', offset:240, timezone:'Europe/Moscow'},
	{city:'Warsaw', offset:120, timezone:'Europe/Warsaw'},
	{city:'Zagreb', offset:120, timezone:'Europe/Zagreb'},
	{city:'Zurich', offset:120, timezone:'Europe/Zurich'}
];
var Africa = [
	{city:'Accra', offset:0, timezone:'Africa/Accra'},
	{city:'Addis Ababa', offset:180, timezone:'Africa/Addis_Ababa'},
	{city:'Algiers', offset:60, timezone:'Africa/Algiers'},
	{city:'Asmera', offset:180, timezone:'Africa/Asmera'},
	{city:'Bamako', offset:0, timezone:'Africa/Bamako'},
	{city:'Bangui', offset:60, timezone:'Africa/Bangui'},
	{city:'Cairo', offset:180, timezone:'Africa/Cairo'},
	{city:'Cape Town', offset:120, timezone:'Africa/Johannesburg'},
	{city:'Conakry', offset:0, timezone:'Africa/Conakry'},
	{city:'Dakar', offset:0, timezone:'Africa/Dakar'},
	{city:'Dar es Salaam', offset:180, timezone:'Africa/Dar_es_Salaam'},
	{city:'Djibouti', offset:180, timezone:'Africa/Djibouti'},
	{city:'Douala', offset:60, timezone:'Africa/Douala'},
	{city:'Freetown', offset:0, timezone:'Africa/Freetown'},
	{city:'Harare', offset:120, timezone:'Africa/Harare'},
	{city:'Kampala', offset:180, timezone:'Africa/Kampala'},
	{city:'Khartoum', offset:180, timezone:'Africa/Khartoum'},
	{city:'Kinshasa', offset:60, timezone:'Africa/Kinshasa'},
	{city:'Lagos', offset:60, timezone:'Africa/Lagos'},
	{city:'Luanda', offset:60, timezone:'Africa/Luanda'},
	{city:'Lusaka', offset:120, timezone:'Africa/Lusaka'},
	{city:'Maputo', offset:120, timezone:'Africa/Maputo'},
	{city:'Mogadishu', offset:180, timezone:'Africa/Mogadishu'},
	{city:'Monrovia', offset:0, timezone:'Africa/Monrovia'},
	{city:'Nairobi', offset:180, timezone:'Africa/Nairobi'},
	{city:'Ndjamena', offset:60, timezone:'Africa/Ndjamena'},
	{city:'Nouakchott', offset:0, timezone:'Africa/Nouakchott'},
	{city:'Ouagadougou', offset:0, timezone:'Africa/Ouagadougou'},
	{city:'Rabat', offset:0, timezone:'Africa/Rabat'},
	{city:'Tripoli', offset:120, timezone:'Africa/Tripoli'},
	{city:'Tunis', offset:60, timezone:'Africa/Tunis'}
];
var NorthAmerica = [
	{city:'Adak', offset:-540, timezone:'America/Adak'},
	{city:'Anchorage', offset:-480, timezone:'America/Anchorage'},
	{city:'Atlanta', offset:-240, timezone:'US/Eastern'},
	{city:'Austin', offset:-300, timezone:'US/Central'},
	{city:'Boston', offset:-240, timezone:'US/Eastern'},
	{city:'Calgary', offset:-360, timezone:'Canada/Mountain'},
	{city:'Chicago', offset:-300, timezone:'America/Chicago'},
	{city:'Columbus', offset:-240, timezone:'US/Eastern'},
	{city:'Cupertino', offset:-420, timezone:'US/Pacific'},
	{city:'Dallas', offset:-300, timezone:'US/Central'},
	{city:'Denver', offset:-360, timezone:'America/Denver'},
	{city:'Detroit', offset:-240, timezone:'America/Detroit'},
	{city:'Guatemala', offset:-360, timezone:'America/Guatemala'},
	{city:'Halifax', offset:-180, timezone:'Canada/Atlantic'},
	{city:'Havana', offset:-240, timezone:'America/Havana'},
	{city:'Indianapolis', offset:-300, timezone:'America/Indianapolis'},
	{city:'Knoxville', offset:-240, timezone:'US/Eastern'},
	{city:'Los Angeles', offset:-420, timezone:'America/Los_Angeles'},
	{city:'Managua', offset:-360, timezone:'America/Managua'},
	{city:'Manchester', offset:-240, timezone:'US/Eastern'},
	{city:'Memphis', offset:-300, timezone:'US/Central'},
	{city:'Mexico City', offset:-300, timezone:'America/Mexico_City'},
	{city:'Miami', offset:-240, timezone:'US/Eastern'},
	{city:'Minneapolis', offset:-300, timezone:'US/Central'},
	{city:'Montréal', offset:-240, timezone:'America/Montreal'},
	{city:'New York', offset:-240, timezone:'America/New_York'},
	{city:'Nuuk', offset:-120, timezone:'America/Godthab'},
	{city:'Ottawa', offset:-240, timezone:'Canada/Eastern'},
	{city:'Panama', offset:-300, timezone:'America/Panama'},
	{city:'Philadelphia', offset:-240, timezone:'US/Eastern'},
	{city:'Phoenix', offset:-420, timezone:'America/Phoenix'},
	{city:'Port-au-Prince', offset:-300, timezone:'America/Port-au-Prince'},
	{city:'Portland', offset:-420, timezone:'US/Pacific'},
	{city:'Regina', offset:-360, timezone:'Canada/Saskatchewan'},
	{city:'Salt Lake City', offset:-360, timezone:'US/Mountain'},
	{city:'San Diego', offset:-420, timezone:'US/Pacific'},
	{city:'San Francisco', offset:-420, timezone:'US/Pacific'},
	{city:'San José', offset:-360, timezone:'America/Costa_Rica'},
	{city:'San Salvador', offset:-360, timezone:'America/El_Salvador'},
	{city:'Santo Domingo', offset:-240, timezone:'America/Santo_Domingo'},
	{city:'Seattle', offset:-420, timezone:'US/Pacific'},
	{city:'St. John\'s', offset:-150, timezone:'Canada/Newfoundland'},
	{city:'St. Louis', offset:-300, timezone:'US/Central'},
	{city:'Tegucigalpa', offset:-360, timezone:'America/Tegucigalpa'},
	{city:'Toronto', offset:-240, timezone:'Canada/Eastern'},
	{city:'Vancouver', offset:-420, timezone:'America/Vancouver'},
	{city:'Washington, D.C.', offset:-240, timezone:'US/Eastern'},
	{city:'Winnipeg', offset:-300, timezone:'America/Winnipeg'}
];
var Asia = [
	{city:'Abu Dhabi', offset:240, timezone:'Asia/Dubai'},
	{city:'Amman', offset:180, timezone:'Asia/Amman'},
	{city:'Anadyr', offset:780, timezone:'Asia/Anadyr'},
	{city:'Ankara', offset:180, timezone:'Europe/Istanbul'},
	{city:'Antananarivo', offset:180, timezone:'Indian/Antananarivo'},
	{city:'Baghdad', offset:240, timezone:'Asia/Baghdad'},
	{city:'Bangkok', offset:420, timezone:'Asia/Bangkok'},
	{city:'Beijing', offset:480, timezone:'Asia/Shanghai'},
	{city:'Beirut', offset:180, timezone:'Asia/Beirut'},
	{city:'Canton', offset:480, timezone:'Asia/Shanghai'},
	{city:'Chennai (Madras)', offset:330, timezone:'Asia/Calcutta'},
	{city:'Colombo', offset:360, timezone:'Asia/Colombo'},
	{city:'Dhaka', offset:360, timezone:'Asia/Dhaka'},
	{city:'Damascus', offset:180, timezone:'Asia/Damascus'},
	{city:'Doha', offset:180, timezone:'Asia/Qatar'},
	{city:'Hanoi', offset:420, timezone:'Asia/Saigon'},
	{city:'Hong Kong', offset:480, timezone:'Asia/Hong_Kong'},
	{city:'Islamabad', offset:300, timezone:'Asia/Karachi'},
	{city:'Jakarta', offset:420, timezone:'Asia/Jakarta'},
	{city:'Jerusalem', offset:180, timezone:'Asia/Jerusalem'},
	{city:'Kabul', offset:270, timezone:'Asia/Kabul'},
	{city:'Katmandu', offset:345, timezone:'Asia/Katmandu'},
	{city:'Kolkata (Calcutta)', offset:330, timezone:'Asia/Calcutta'},
	{city:'Krasnoyarsk', offset:480, timezone:'Asia/Krasnoyarsk'},
	{city:'Kuala Lumpur', offset:480, timezone:'Asia/Kuala_Lumpur'},
	{city:'Kuwait', offset:180, timezone:'Asia/Kuwait'},
	{city:'Magadan', offset:720, timezone:'Asia/Magadan'},
	{city:'Male', offset:300, timezone:'Indian/Maldives'},
	{city:'Manama', offset:180, timezone:'Asia/Bahrain'},
	{city:'Manila', offset:480, timezone:'Asia/Manila'},
	{city:'Mecca', offset:180, timezone:'Asia/Riyadh'},
	{city:'Mumbai (Bombay)', offset:330, timezone:'Asia/Calcutta'},
	{city:'Muscat', offset:240, timezone:'Asia/Muscat'},
	{city:'New Delhi', offset:330, timezone:'Asia/Calcutta'},
	{city:'Novosibirsk', offset:420, timezone:'Asia/Novosibirsk'},
	{city:'Omsk', offset:420, timezone:'Asia/Omsk'},
	{city:'Osaka', offset:540, timezone:'Japan'},
	{city:'Phnom Penh', offset:420, timezone:'Asia/Phnom_Penh'},
	{city:'Port Louis', offset:240, timezone:'Indian/Mauritius'},
	{city:'Pyongyang', offset:540, timezone:'Asia/Pyongyang'},
	{city:'Rangoon', offset:390, timezone:'Asia/Rangoon'},
	{city:'Riyadh', offset:180, timezone:'Asia/Riyadh'},
	{city:'Sanaa', offset:180, timezone:'Asia/Aden'},
	{city:'Seoul', offset:540, timezone:'Asia/Seoul'},
	{city:'Shanghai', offset:480, timezone:'Asia/Shanghai'},
	{city:'Singapore', offset:480, timezone:'Asia/Singapore'},
	{city:'Taipei', offset:480, timezone:'Asia/Taipei'},
	{city:'Tashkent', offset:300, timezone:'Asia/Tashkent'},
	{city:'Tehran', offset:270, timezone:'Asia/Tehran'},
	{city:'Thanh Pho Ho Chi Minh', offset:420, timezone:'Asia/Saigon'},
	{city:'Tientsin', offset:480, timezone:'Asia/Shanghai'},
	{city:'Tokyo', offset:540, timezone:'Japan'},
	{city:'Ulaanbaatar', offset:480, timezone:'Asia/Ulaanbaatar'},
	{city:'Victoria', offset:240, timezone:'Indian/Mahe'},
	{city:'Vladivostok', offset:660, timezone:'Asia/Vladivostok'},
	{city:'Yakutsk', offset:600, timezone:'Asia/Yakutsk'},
	{city:'Yekaterinburg', offset:360, timezone:'Asia/Yekaterinburg'}
];
var Australia = [
	{city:'Adelaide', offset:570, timezone:'Australia/Adelaide'},
	{city:'Brisbane', offset:600, timezone:'Australia/Brisbane'},
	{city:'Canberra', offset:600, timezone:'Australia/Canberra'},
	{city:'Darwin', offset:570, timezone:'Australia/Darwin'},
	{city:'Hobart', offset:600, timezone:'Australia/Hobart'},
	{city:'Melbourne', offset:600, timezone:'Australia/Melbourne'},
	{city:'Perth', offset:480, timezone:'Australia/Perth'},
	{city:'Sydney', offset:600, timezone:'Australia/Sydney'}
];

var continents = [
	{name:"Africa", array:Africa},
	{name:"Asia", array:Asia},
	{name:"Atlantic", array:Atlantic},
	{name:"Australia", array:Australia},
	{name:"Europe", array:Europe},
	{name:"North America", array:NorthAmerica},
	{name:"Pacific", array:Pacific},
	{name:"South America", array:SouthAmerica}
];

var targetLocale = "San Francisco";
var targetGMTOffset = 480; // offset of target locale, in minutes

var	originalSeconds = 0;

//==========================================================
//  Constants that control second hand "sproing" animation
//==========================================================
//  To simulate a mechanical second hand motion, we will:
//    - Go to T+n
//    - Go to T-n
//    - Go to T+(n/2)
//    - Go to T-(n/2)
//    - Go to T+(n/4)
//    - Go to T-(n/4)
//    - Go to T

var secondsSweepbackAnimateInterval = 35;
var secondsSweepbackMax = 0.15;
var secondsSweepbackAmounts = new Array( -2*secondsSweepbackMax, 1.5*secondsSweepbackMax,
										 -secondsSweepbackMax, 0.75*secondsSweepbackMax,
										 -0.5*secondsSweepbackMax, 0.25*secondsSweepbackMax );

var secondSweepbackAnimation = {step:0, timer:null};

var timerInterval = null;

var minutesAngle;
var hoursAngle;

function getLocalizedString (key)
{
	try {
		return localizedStrings[key];
	} catch (ex) {}

	return key;
}

function getLocalizedCityName (key)
{
	try {
		return localizedCityNames[key];
	} catch (ex) {}

	return key;
}

function getLocalizedContinentName (key)
{
	try {
		return localizedContinentNames[key];
	} catch (ex) {}

	return key;
}

function updateDefaultCityAndContinent()
{
	// reset defaults to cupertino, north america
	defaultCityIndex = 8;
	defaultContinentIndex = 5;

	if (window.TimeZoneInfo) {
		var continentName = TimeZoneInfo.getDefaultContinentName();
		var count = continents.length;
				
		for(i = 0; i < count; i++)
		{
			if (continentName == continents[i].name)
			{
				defaultContinentIndex = i;
				break;
			}
		}
		
		// if we're not in north america, default to first city in time zone
		if (continentName != "North America")
			defaultCityIndex = 0;
		
		// get city
		cityName = TimeZoneInfo.getDefaultCityName();
		// find city in 
		
		var cityArray = continents[defaultContinentIndex].array;
		count = cityArray.length;
		var found = false;
		for(i = 0; i < count; i++)
		{
			if (cityName == cityArray[i].city)
			{
				defaultCityIndex = i;
				found = true;
				break;
			}
		}
		if (!found)
			checkForSpecialCaseCities(cityName);
			
	}	
}

function checkForSpecialCaseCities(city)
{
	// these all have some funky characters in their names in the arrays
	// but the name returned from the plugin doesn't so we need to do a
	// special lookup here.
	if (city == 'Reykjavik')
	{
		defaultCityIndex = 2;
		defaultContinentIndex = 2;	
	}
	else if (city == 'Asuncion')
	{
		defaultCityIndex = 0;
		defaultContinentIndex = 7;	
	}
	else if (city == 'Bogota')
	{
		defaultCityIndex = 1;
		defaultContinentIndex = 7;	
	}
	else if (city == 'Brasalia')
	{
		defaultCityIndex = 2;
		defaultContinentIndex = 7;	
	}
	else if (city == 'San Jose')
	{
		defaultCityIndex = 37;
		defaultContinentIndex = 5;	
	}
	else if (city == 'Sao Paulo')
	{
		defaultCityIndex = 16;
		defaultContinentIndex = 7;	
	}
	else if (city == 'Noumea')
	{
		defaultCityIndex = 2;
		defaultContinentIndex = 6;	
	}
}


function isEvening (date)
{
	var hours = date.getHours();
		
	return hours < 6 || hours > 17;
}
var isItEvening = isEvening(new Date);
var isItAM = isAM (new Date);

function isAM (date)
{
	return date.getHours() < 12;
}

var minhand = new Image (17, 53);
if (isItEvening)
	minhand.src = 'Images/pmmins.pdf';
else
	minhand.src = 'Images/mins.pdf';


var sechand = new Image (7, 55);
sechand.src = 'Images/secs.pdf';

var hourhand = new Image (13, 27);
if (isItEvening)
	hourhand.src = 'Images/pmhour.pdf';
else
	hourhand.src = 'Images/hour.pdf';

/* <sko>
function secondSweepback() {
	originalSeconds = originalSeconds - secondsSweepbackAmount;
	var secondsAngle = originalSeconds * 0.10471975511965977; // all angles computed in radians

	drawHands (hoursAngle, minutesAngle, secondsAngle);
}
*/

function secondSweepbackAnimate()
{
	if ( secondSweepbackAnimation.step >= secondsSweepbackAmounts.length )
	{
		//  no more steps to the animation, so clear the timer
		clearInterval(secondSweepbackAnimation.timer);
		secondSweepbackAnimation.timer = null;
		secondSweepbackAnimation.step = 0;
	}
	else
	{
		originalSeconds = originalSeconds + secondsSweepbackAmounts[secondSweepbackAnimation.step];
		var secondsAngle = originalSeconds * 0.10471975511965977; // all angles computed in radians
		
		drawHands (hoursAngle, minutesAngle, secondsAngle);
		
		secondSweepbackAnimation.step++;
	}
}	

function updateTime(doSweepBack)
{
	var now = new Date();
	var evening;
	
	var ourGMTOffset = now.getTimezoneOffset();
	if (window.TimeZoneInfo) {
		targetGMTOffset = TimeZoneInfo.getTimezoneOffsetForTimezoneName(continents[defaultContinentIndex].array[defaultCityIndex].timezone);
	}	
	else {	
		// Fall back to offset
		targetGMTOffset = continents[defaultContinentIndex].array[defaultCityIndex].offset;
	}

	now.setTime(now.getTime() + ((ourGMTOffset + targetGMTOffset) * 60 * 1000));

//
// change the face if necessary
//
	evening = isEvening(now);
	if (evening != isItEvening)
	{
		isItEvening = evening;
		var img = document.getElementById("clock-image");
		if (evening)
		{
			hourhand.src = 'Images/pmhour.pdf';
			minhand.src = 'Images/pmmins.pdf';
			img.src = 'Images/pmbase.png';
		}
		else
		{
			hourhand.src = 'Images/hour.pdf';
			minhand.src = 'Images/mins.pdf';
			img.src = 'Images/base.png';
		}
	}
	
	var am = isAM(now);
	if (am != isItAM)
	{
		isItAM = am;
	 	document.getElementById('ampm').innerText = getLocalizedString(isItAM ? 'AM' : 'PM');
	}

	originalSeconds = now.getSeconds()+secondsSweepbackMax;
	var secondsAngle = originalSeconds * 0.10471975511965977; // all angles computed in radians
	minutesAngle = now.getMinutes() * 0.10471975511965977;
	hoursAngle = ((now.getHours()%12) * 0.523598775598) + (minutesAngle/6.283185481853 * 0.523598775598);

	drawHands (hoursAngle, minutesAngle, secondsAngle);

	if (doSweepBack)
	{
		if ( secondSweepbackAnimation.timer != null )
		{
			clearInterval( secondSweepbackAnimation.timer );
			secondSweepbackAnimation.timer = null;
		}
		secondSweepbackAnimation.step = 0;
		secondSweepbackAnimation.timer = setInterval("secondSweepbackAnimate();", secondsSweepbackAnimateInterval);
	}
}

function startSecondHandTimer()
{
	if ( timerInterval != null )
	{
		clearInterval( timerInterval );
		timerInterval = null;
	}
	
	timerInterval = setInterval("updateTime(true);", 1000);
}

function clearHands()
{
	var canvas =    document.getElementById("canvas");
	var context = canvas.getContext("2d");
	
	context.clearRect (0, 0, 172, 172);
}

function drawHands (hoursAngle, minutesAngle, secondsAngle)
{
	var canvas =    document.getElementById("canvas");
	var context = canvas.getContext("2d");
	
	context.clearRect (0, 0, 172, 172);

	context.save();
	context.translate (172/2, 172/2 -4);

	context.save();
	context.rotate (hoursAngle);
	context.translate (-7, -28.5);
	context.drawImage (hourhand, 0, 0, 13, 27);
	context.restore();
	
	context.save();
	context.rotate (minutesAngle);
	context.translate (-8.5, -44);
	context.drawImage (minhand, 0, 0, 17, 53);
	context.restore();

	context.rotate (secondsAngle);
	context.translate (-3.5,-50.5);
	context.drawImage (sechand, 0, 0, 7, 55);

	context.restore();

//  context.setFillColor ("black");
//  context.fillRect(172/2, 0, 1, 172);
//  context.fillRect(0, (172/2)-4, 172, 1);
}

function onshow () {
	if (timerInterval == null) {
		startSecondHandTimer();
	}
	updateTime(false);
}

function onhide () {
	if (timerInterval != null) {
	
		// we were hidden clear the hands
		clearHands();
		
		// clear the timer
		clearInterval(timerInterval);
		timerInterval = null;
	}
}

function showbackside(event)
{
	var front = document.getElementById("front");
	var back = document.getElementById("behind");
	
	if (window.widget)
		widget.prepareForTransition("ToBack");
	onhide();
	
	front.style.display="none";
	back.style.display="block";
	
	if (window.widget)
		setTimeout ('widget.performTransition();', 0);	


	document.getElementById('fliprollie').style.display = 'none';
}


function doneClicked() {
        var front = document.getElementById("front");
        var back = document.getElementById("behind");

        if (window.widget)
                widget.prepareForTransition("ToFront");


        front.style.display="block";
        back.style.display="none";

        setTimeout ('flipitback();', 0);
        onshow();

}


function flipitback()
{
	updateTime(false);
	if (window.widget)
		setTimeout("widget.performTransition();", 0);
}


if (window.widget) {
	data = widget.preferenceForKey("locale");
	widget.onhide = onhide;
	widget.onshow = onshow;
}


function clockLoaded() {
	var data = null;
		
	if (data == null) {
		data = targetLocale;
	}
		
	//var element = document.getElementById("localeDisplay");
	//element.innerHTML = data;
	
	startSecondHandTimer();
}

var flipShown = false;

var animation = {duration:0, starttime:0, to:1.0, now:0.0, from:0.0, element:null, timer:null};


//  Returns val if min < val < max
//  Returns min if val <= min
//  Returns max if val >= max

function limit_3 (val, min, max)
{
    return val < min ? min : (val > max ? max : val);
}

function computeNextFloat (from, to, ease)
{
    return from + (to - from) * ease;
}

function animate()
{
	var T;
	var ease;
	var time = (new Date).getTime();
		
	
	T = limit_3(time-animation.starttime, 0, animation.duration);
	
	if (T >= animation.duration)
	{
		clearInterval (animation.timer);
		animation.timer = null;
		animation.now = animation.to;
	}
	else
	{
		ease = 0.5 - (0.5 * Math.cos(Math.PI * T / animation.duration));
		animation.now = computeNextFloat (animation.from, animation.to, ease);
	}
	
	animation.element.style.opacity = animation.now;
}


function mousemove (event)
{
	if (!flipShown)
	{
		// fade in the flip widget
		if (animation.timer != null)
		{
			clearInterval (animation.timer);
			animation.timer  = null;
		}
		
		var starttime = (new Date).getTime() - 13; // set it back one frame
		
		animation.duration = 500;
		animation.starttime = starttime;
		animation.element = document.getElementById ('flip');
		animation.timer = setInterval ("animate();", 13);
		animation.from = animation.now;
		animation.to = 1.0;
		animate();
		flipShown = true;
	}
}

function mouseexit (event)
{
	if (flipShown)
	{
		// fade in the flip widget
		if (animation.timer != null)
		{
			clearInterval (animation.timer);
			animation.timer  = null;
		}
		
		var starttime = (new Date).getTime() - 13; // set it back one frame
		
		animation.duration = 500;
		animation.starttime = starttime;
		animation.element = document.getElementById ('flip');
		animation.timer = setInterval ("animate();", 13);
		animation.from = animation.now;
		animation.to = 0.0;
		animate();
		flipShown = false;
	}
}

function populateContinentSelect()
{
	var select = document.getElementById ('continent-popup');
	var c = continents.length;
	
	for (var i = 0; i < c; ++i)
	{

		var element = document.createElement("option");
		element.innerText = getLocalizedContinentName(continents[i].name);
		select.appendChild (element);
	}
}

function popuplateCitySelect(cities)
{
	var select = document.getElementById ('city-popup');
	
	// remove all children
	while (select.hasChildNodes())
		select.removeChild(select.firstChild);
	
	var c = cities.length;
	
	for (var i = 0; i < c; ++i)
	{
		var element = document.createElement("option");
		element.innerText = getLocalizedCityName(cities[i].city);
		select.appendChild (element);
	}
}

function createkey(key)
{
	return widget.identifier + "-" + key;
}

function continentchanged (select)
{
	if (defaultContinentIndex != select.selectedIndex)
	{
		defaultContinentIndex = select.selectedIndex;
		popuplateCitySelect(continents[defaultContinentIndex].array);
		defaultCityIndex = 0;
	 	document.getElementById ('city-popup').options[defaultCityIndex].selected = true;
	 	document.getElementById("localeDisplay").innerText= getLocalizedCityName(continents[defaultContinentIndex].array[defaultCityIndex].city);
	
		if (window.widget)
		{
			widget.setPreferenceForKey (defaultContinentIndex.toString(), createkey("continent"));
			widget.setPreferenceForKey (defaultCityIndex.toString(), createkey("city"));
			
		}
	}
}

function citychanged (select)
{
	if (defaultCityIndex != select.selectedIndex)
	{
		defaultCityIndex = select.selectedIndex;
	 	document.getElementById("localeDisplay").innerText= getLocalizedCityName(continents[defaultContinentIndex].array[defaultCityIndex].city);
	 	
		if (window.widget)
		{
			widget.setPreferenceForKey (defaultContinentIndex.toString(), createkey("continent"));
			widget.setPreferenceForKey (defaultCityIndex.toString(), createkey("city"));
		}
	}
}

function onremove ()
{
	if (window.widget)
	{
		widget.setPreferenceForKey (null, createkey("continent"));
		widget.setPreferenceForKey (null, createkey("city"));
	}
}

if (window.widget)
{
	widget.onremove = onremove;
}

function enterflip(event)
{
	document.getElementById('fliprollie').style.display = 'block';
}

function exitflip(event)
{
	document.getElementById('fliprollie').style.display = 'none';
}

function debug(msg) {
	if (!debug.box) {
		debug.box = document.createElement("div");
		debug.box.setAttribute("style", "background-color: white; " +
										"font-family: monospace; " +
										"border: solid black 3px; " +
										"position: absolute;top:300px;" +
										"padding: 10px;");
		document.body.appendChild(debug.box);
		debug.box.innerHTML = "<h1 style='text-align:center'>Debug Output</h1>";
	}
	
	var p = document.createElement("p");
	p.appendChild(document.createTextNode(msg));
	debug.box.appendChild(p);
}
